/*
  +------------------------------------------------------------------+
  | Allows you to enter two SMA periods and it will then show you at |
  | Which point they crossed over. It is more usful on the shorter   |
  | periods that get obscured by the bars / candlesticks and when    |
  | the zoom level is out. Also allows you then to remove the SMAs   |
  | from the chart. (SMAs are initially set at 10 and 20)              |
  +------------------------------------------------------------------+
*/   

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red

double CrossUp[];
double CrossDown[];
extern int FasterSMA = 10;
extern int FasterPeriodMode =  0; //0=sma, 1=ema, 2=smma, 3=lwma
extern int FasterPriceMaMode =  0; //0=price close, 1=price open, 2=price high, 3=price low, 4=price median, 5=price typical, 6=price weighted
extern int SlowerSMA = 20;
extern int SlowerPeriodMode =  0; //0=sma, 1=ema, 2=smma, 3=lwma
extern int SlowerPriceMaMode =  0; //0=price close, 1=price open, 2=price high, 3=price low, 4=price median, 5=price typical, 6=price weighted
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0, DRAW_ARROW, EMPTY);
   SetIndexArrow(0, 233);
   SetIndexBuffer(0, CrossUp);
   SetIndexStyle(1, DRAW_ARROW, EMPTY);
   SetIndexArrow(1, 234);
   SetIndexBuffer(1, CrossDown);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int limit, i, counter;
   double fasterSMAnow, slowerSMAnow, fasterSMAprevious, slowerSMAprevious, fasterSMAafter, slowerSMAafter;
   double Range, AvgRange;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;
   
   for(i = 0; i <= limit; i++) {
   
      counter=i;
      Range=0;
      AvgRange=0;
      for (counter=i ;counter<=i+9;counter++) {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }
      Range=AvgRange/10;
       
      fasterSMAnow = iMA(NULL, 0, FasterSMA, 0, FasterPeriodMode, FasterPriceMaMode, i);
      fasterSMAprevious = iMA(NULL, 0, FasterSMA, 0, FasterPeriodMode, FasterPriceMaMode, i+1);
      

      slowerSMAnow = iMA(NULL, 0, SlowerSMA, 0, SlowerPeriodMode, SlowerPriceMaMode, i);
      slowerSMAprevious = iMA(NULL, 0, SlowerSMA, 0, SlowerPeriodMode, SlowerPriceMaMode, i+1);
      
      
      if ((fasterSMAnow > slowerSMAnow) && (fasterSMAprevious < slowerSMAprevious)) {
         CrossUp[i] = Low[i] - Range*0.5;
      }
      else if ((fasterSMAnow < slowerSMAnow) && (fasterSMAprevious > slowerSMAprevious)) {
         CrossDown[i] = High[i] + Range*0.5;
      }
   }
   return(0);
}

